/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nways.tools.regexp;

import com.ibm.nways.tools.regexp.RegExpException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;

public class RegExp {
    public boolean debug = false;
    String pattern;
    int currIndex;
    char currChar;
    int currCharType;
    int numBacktraces;
    Pattern compiledPattern;
    String matchString;
    String[] matchBacktraces;
    boolean matchTrace;
    Vector nestedPatterns = new Vector();
    static final int CHAR_EOF = 0;
    static final int CHAR_NORMAL = 1;
    static final int CHAR_META = 2;
    static final int CHAR_EMPTY = 3;
    private static String[] charTypeNames = new String[]{"<EOF>", "normal", "meta", "empty"};

    private RegExp() {
    }

    public RegExp(String string) throws RegExpException {
        this.pattern = string;
        this.compiledPattern = this.parse();
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getMaxBacktraces() {
        return this.numBacktraces;
    }

    private Pattern parse() throws RegExpException {
        this.currIndex = 0;
        this.nextChar();
        Root root = new Root();
        Pattern pattern = this.RE(root);
        if (pattern == null) {
            root = null;
        }
        root.p = pattern;
        return root;
    }

    private Pattern RE(Pattern pattern) throws RegExpException {
        Alternative alternative = new Alternative(pattern);
        Pattern pattern2 = this.RT(alternative);
        while (pattern2 != null) {
            alternative.elems.addElement(pattern2);
            if (this.currCharType != 2 || this.currChar != '|') break;
            this.nextChar();
            pattern2 = this.RT(alternative);
            if (pattern2 != null) continue;
            throw this.expected("<RE>");
        }
        if (alternative.elems.size() == 0) {
            alternative = null;
        } else if (alternative.elems.size() == 1) {
            Pattern pattern3 = (Pattern)alternative.elems.elementAt(0);
            pattern3.parent = pattern;
            return pattern3;
        }
        return alternative;
    }

    private Pattern RT(Pattern pattern) throws RegExpException {
        Concat concat = new Concat(pattern);
        Pattern pattern2 = this.RF(concat);
        while (pattern2 != null) {
            concat.elems.addElement(pattern2);
            pattern2 = this.RF(concat);
        }
        if (concat.elems.size() == 0) {
            concat = null;
        } else if (concat.elems.size() == 1) {
            Pattern pattern3 = (Pattern)concat.elems.elementAt(0);
            pattern3.parent = pattern;
            return pattern3;
        }
        return concat;
    }

    private Pattern RF(Pattern pattern) throws RegExpException {
        Pattern pattern2 = null;
        block0 : switch (this.currCharType) {
            case 1: {
                pattern2 = new Char(pattern, 1, this.currChar);
                this.nextChar();
                break;
            }
            case 2: {
                switch (this.currChar) {
                    case '.': 
                    case 'D': 
                    case 'S': 
                    case 'W': 
                    case 'd': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'w': {
                        pattern2 = new Char(pattern, 2, this.currChar);
                        this.nextChar();
                        break block0;
                    }
                    case '(': {
                        int n = this.numBacktraces++;
                        Nested nested = new Nested(pattern, n);
                        pattern2 = nested;
                        this.nestedPatterns.addElement(pattern2);
                        this.nextChar();
                        Pattern pattern3 = this.RE(pattern2);
                        if (this.currCharType == 2 && this.currChar == ')' && pattern3 != null) {
                            this.nextChar();
                            nested.p = pattern3;
                            break block0;
                        }
                        throw this.expected(")");
                    }
                }
            }
        }
        if (pattern2 == null) {
            return null;
        }
        if (this.currCharType == 2) {
            Char char_ = pattern2;
            if (this.currChar == '+') {
                pattern2 = new Repeated(pattern, char_, 1, -1);
                char_.parent = pattern2;
                this.nextChar();
            } else if (this.currChar == '*') {
                pattern2 = new Repeated(pattern, pattern2, 0, -1);
                char_.parent = pattern2;
                this.nextChar();
            } else if (this.currChar == '?') {
                pattern2 = new Repeated(pattern, pattern2, 0, 1);
                char_.parent = pattern2;
                this.nextChar();
            }
        }
        return pattern2;
    }

    private void nextChar() throws RegExpException {
        if (this.currIndex < this.pattern.length()) {
            this.currChar = this.pattern.charAt(this.currIndex);
            block0 : switch (this.currChar) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '|': {
                    this.currCharType = 2;
                    break;
                }
                case '\\': {
                    ++this.currIndex;
                    if (this.currIndex < this.pattern.length()) {
                        this.currChar = this.pattern.charAt(this.currIndex);
                        switch (this.currChar) {
                            case 'D': 
                            case 'S': 
                            case 'W': 
                            case 'd': 
                            case 's': 
                            case 'w': {
                                this.currCharType = 2;
                                break block0;
                            }
                        }
                        this.currCharType = 1;
                        break;
                    }
                    throw new RegExpException("Expression ends with \\");
                }
                default: {
                    this.currCharType = 1;
                }
            }
            ++this.currIndex;
            return;
        }
        this.currCharType = 0;
        this.currChar = '\u0000';
    }

    public boolean match(String string) {
        return this.match(string, null, false);
    }

    public boolean match(String string, String[] stringArray) {
        return this.match(string, stringArray, false);
    }

    boolean match(String string, String[] stringArray, boolean bl) {
        int n;
        int n2;
        boolean bl2 = false;
        this.matchString = string;
        this.matchBacktraces = stringArray;
        if (stringArray != null) {
            Enumeration enumeration = this.nestedPatterns.elements();
            while (enumeration.hasMoreElements()) {
                Nested nested = (Nested)enumeration.nextElement();
                nested.endIndex = -1;
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = null;
                ++n2;
            }
        }
        if ((n = this.compiledPattern.match(0)) >= 0) {
            bl2 = true;
            if (stringArray != null) {
                n2 = 0;
                Enumeration enumeration = this.nestedPatterns.elements();
                while (enumeration.hasMoreElements() && n2 < stringArray.length) {
                    Nested nested = (Nested)enumeration.nextElement();
                    if (nested.endIndex >= 0) {
                        stringArray[n2] = this.matchString.substring(nested.startIndex, nested.endIndex);
                    }
                    ++n2;
                }
            }
        }
        return bl2;
    }

    private RegExpException expected(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Found '");
        stringBuffer.append(this.currChar);
        stringBuffer.append("' at end of \"");
        stringBuffer.append(this.pattern.substring(0, this.currIndex));
        stringBuffer.append("\" and expected '");
        stringBuffer.append(string);
        stringBuffer.append("'");
        return new RegExpException(stringBuffer.toString());
    }

    private char charAt(String string, int n) {
        if (n >= string.length()) {
            return '\u0000';
        }
        return string.charAt(n);
    }

    private boolean charMatch(char c, int n, char c2) {
        boolean bl = false;
        if (c == '\u0000') {
            return false;
        }
        block0 : switch (n) {
            case 1: {
                bl = c == c2;
                break;
            }
            case 2: {
                switch (c2) {
                    case '#': 
                    case '.': {
                        bl = true;
                        break block0;
                    }
                    case 'w': {
                        bl = Character.isLetterOrDigit(c) || c == '_';
                        break block0;
                    }
                    case 'W': {
                        bl = !Character.isLetterOrDigit(c) && c != '_';
                        break block0;
                    }
                    case 's': {
                        bl = Character.isWhitespace(c);
                        break block0;
                    }
                    case 'S': {
                        bl = !Character.isWhitespace(c);
                        break block0;
                    }
                    case 'd': {
                        bl = Character.isDigit(c);
                        break block0;
                    }
                    case 'D': {
                        bl = !Character.isDigit(c);
                        break block0;
                    }
                    case 'n': {
                        bl = c == '\n';
                        break block0;
                    }
                    case 'r': {
                        bl = c == '\r';
                        break block0;
                    }
                    case 'f': {
                        bl = c == '\f';
                        break block0;
                    }
                    case 't': {
                        bl = c == '\t';
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Matching metachar " + c2 + " unsupported");
            }
            default: {
                throw new IllegalArgumentException("Should not attempt charMatch of charType " + n);
            }
        }
        return bl;
    }

    public String toString() {
        System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    static String stringFromCharType(int n) {
        if (n >= charTypeNames.length) {
            return "***ILLEGAL CHARTYPE***";
        }
        return charTypeNames[n];
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length > 0 && stringArray[0].equals("debug")) {
            bl = true;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block4: while (true) {
            String string;
            System.out.print("Regular expression or <ENTER> to quit: ");
            System.out.flush();
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                return;
            }
            if (string == null) break;
            if (string.length() == 0) {
                return;
            }
            try {
                RegExp regExp = new RegExp(string);
                if (bl) {
                    System.out.println(regExp);
                }
                block5: while (true) {
                    String[] stringArray2 = new String[regExp.getMaxBacktraces()];
                    System.out.print("  input or <ENTER> to quit: ");
                    System.out.flush();
                    String string2 = bufferedReader.readLine();
                    if (string2 == null || string2.length() == 0) continue block4;
                    if (regExp.match(string2, stringArray2)) {
                        System.out.println("    matched, backtraces:");
                        int n = 0;
                        while (true) {
                            if (n >= stringArray2.length) continue block5;
                            if (stringArray2[n] != null) {
                                System.out.println("      " + n + ":\"" + stringArray2[n] + "\"");
                            }
                            ++n;
                        }
                    }
                    System.out.println("    not matched");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    abstract class Pattern {
        int startIndex;
        int endIndex = -1;
        Pattern parent;

        public Pattern(Pattern pattern) {
            RegExp.this = RegExp.this;
            this.parent = pattern;
        }

        public abstract int match(int var1);

        public abstract int matchRest(int var1);
    }

    class Root
    extends Pattern {
        Pattern p;

        public Root() {
            super(null);
            RegExp.this = RegExp.this;
        }

        public int match(int n) {
            this.startIndex = n;
            this.endIndex = this.p.match(n);
            if (this.endIndex != RegExp.this.matchString.length()) {
                return -1;
            }
            return this.endIndex;
        }

        public int matchRest(int n) {
            if (n != RegExp.this.matchString.length()) {
                return -1;
            }
            return n;
        }
    }

    class Alternative
    extends Pattern {
        Vector elems = new Vector();
        int currElemIndex;

        public Alternative(Pattern pattern) {
            super(pattern);
            RegExp.this = RegExp.this;
        }

        public int match(int n) {
            this.startIndex = n;
            this.currElemIndex = 0;
            this.currElemIndex = 0;
            while (this.currElemIndex < this.elems.size()) {
                Pattern pattern = (Pattern)this.elems.elementAt(this.currElemIndex);
                this.endIndex = pattern.match(n);
                if (this.endIndex >= 0) break;
                ++this.currElemIndex;
            }
            return this.endIndex;
        }

        public int matchRest(int n) {
            return this.parent.matchRest(n);
        }
    }

    class Concat
    extends Pattern {
        Vector elems = new Vector();
        int currElemIndex;
        boolean matched;

        public Concat(Pattern pattern) {
            super(pattern);
            RegExp.this = RegExp.this;
        }

        public int match(int n) {
            this.startIndex = n;
            this.currElemIndex = 0;
            this.matched = false;
            int n2 = n;
            this.currElemIndex = 0;
            while (!this.matched && this.currElemIndex < this.elems.size()) {
                Pattern pattern = (Pattern)this.elems.elementAt(this.currElemIndex);
                n2 = pattern.match(n2);
                if (n2 < 0) break;
                ++this.currElemIndex;
            }
            if (!this.matched) {
                this.endIndex = n2;
            }
            return this.endIndex;
        }

        public int matchRest(int n) {
            int n2 = n;
            int n3 = this.currElemIndex++;
            while (this.currElemIndex < this.elems.size()) {
                Pattern pattern = (Pattern)this.elems.elementAt(this.currElemIndex);
                n2 = pattern.match(n2);
                if (this.currElemIndex >= this.elems.size() || n2 < 0) break;
                ++this.currElemIndex;
            }
            if (n2 >= 0) {
                if (!this.matched) {
                    int n4 = this.parent.matchRest(n2);
                    if (n4 >= 0) {
                        this.matched = true;
                        this.endIndex = n2;
                    } else {
                        n2 = -1;
                    }
                }
            } else {
                this.currElemIndex = n3;
            }
            return n2;
        }
    }

    class Char
    extends Pattern {
        int charType;
        char c;

        public Char(Pattern pattern, int n, char c) {
            super(pattern);
            RegExp.this = RegExp.this;
            this.charType = n;
            this.c = c;
        }

        public int match(int n) {
            this.startIndex = n;
            boolean bl = RegExp.this.charMatch(RegExp.this.charAt(RegExp.this.matchString, n), this.charType, this.c);
            this.endIndex = bl ? n + 1 : -1;
            return this.endIndex;
        }

        public int matchRest(int n) {
            return this.parent.matchRest(n);
        }
    }

    class Nested
    extends Pattern {
        int backtraceNumber;
        Pattern p;

        public Nested(Pattern pattern, int n) {
            super(pattern);
            RegExp.this = RegExp.this;
            this.backtraceNumber = n;
        }

        public int match(int n) {
            int n2 = this.p.match(n);
            if (n2 >= 0) {
                this.startIndex = n;
                this.endIndex = n2;
            }
            return n2;
        }

        public int matchRest(int n) {
            int n2 = this.parent.matchRest(n);
            return n2;
        }
    }

    class Repeated
    extends Pattern {
        int min;
        int max;
        Pattern p;

        public Repeated(Pattern pattern, Pattern pattern2, int n, int n2) {
            super(pattern);
            RegExp.this = RegExp.this;
            this.p = pattern2;
            this.min = n;
            this.max = n2;
        }

        /*
         * Unable to fully structure code
         */
        public int match(int var1_1) {
            block3: {
                block4: {
                    var2_2 = new Vector<Integer>();
                    this.startIndex = var1_1;
                    var4_3 = var1_1;
                    var2_2.addElement(new Integer(var4_3));
                    for (var3_4 = 0; (this.max < 0 || var3_4 < this.max) && (var4_3 = this.p.match(var4_3)) >= 0; ++var3_4) {
                        var2_2.addElement(new Integer(var4_3));
                    }
                    break block4;
lbl9:
                    // 1 sources

                    while (true) {
                        var5_5 = (Integer)var2_2.elementAt(var3_4);
                        this.endIndex = var5_5;
                        var4_3 = this.parent.matchRest(this.endIndex);
                        if (var4_3 >= 0) break block3;
                        --var3_4;
                        break;
                    }
                }
                ** while (var3_4 >= this.min)
            }
            if (var4_3 >= 0) {
                return this.endIndex;
            }
            return -1;
        }

        public int matchRest(int n) {
            return n;
        }
    }
}

